Import-Module FailoverClusters;

$clusterName = "WINCLUST-01" # Nom du cluster
$node = "SQL141"              # Nom du noeud sur lequel le journal de cluster sera gnr
$log_path = "C\CLUSTERLOG"    # Chemin de gnration du fichier journal de cluster
$timespan = 30                # Intervalle de recouvrement des donnes (en minutes)

Get-ClusterLog -Node $node -Cluster $clusterName -Destination $log_path -TimeSpan $timespan -UseLocalTime ;

$log_path_file = "$log_path\$node" + "_cluster.log";

Write-Host $log_path_file;

Get-Content -Path $log_path_file | Select-String -Pattern "SQL Server(.)*OnlinePending-->Online" | Out-String;

